package cn.com.duiba.oto.bean;

import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/1/9 16:39
 * @Description:
 */
@Data
public class CustBuyPreferentialBean implements Serializable {

    private static final long serialVersionUID = -724039764641154063L;

    private static final Integer EXTEND_DAYS = 36500;

    /**
     * 是否垃圾池用户
     */
    @JSONField(serialize = false)
    public Boolean garbage = false;
    /**
     * 客户id
     */
    @JSONField(serialize = false)
    private Long custId;
    /**
     * 本次之前已经累计享受时长
     */
    private Integer allDays;
    /**
     * 当次享受开始时间
     */
    private Date lastStart;
    /**
     * 当次享受结束时间
     */
    private Date lastEnd;

    public Boolean inPreferential() {
        if (garbage) {
            return false;
        }
        if (this.lastEnd == null || this.lastStart == null) {
            return true;
        }
        // 检查当前时间是否在优惠期内
        final Date now = new Date();
        // 如果当前时间在优惠期开始和结束之间，则返回true，否则返回false
        if (now.after(this.lastStart) && now.before(this.lastEnd)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 获取所享受优惠的总时长
     */
    public int getAllDays() {
        int count = 0;
        final Date now = new Date();
        if (Objects.nonNull(allDays)) {
            count = count + allDays;
        }
        if (Objects.nonNull(lastStart) && lastStart.before(now)) {
            count = count + DateUtils.daysBetween(DateUtils.getDayEndTime(lastStart), DateUtils.getDayEndTime(now));
        }
        return count;
    }

    /**
     * 获取延长时长
     */
    public Integer getExtendDays() {
        if (this.garbage) {
            return 0;
        }
        if (NumberUtil.isNotNullOrLteZero(custId)) {
            return 36500;
        }
        return 0;
    }
}
