package cn.com.duiba.oto.dto.oto.activity;

import cn.com.duiba.oto.enums.activity.BizActivityTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信用户活动报名记录表
 *
 * @TableName tb_oto_biz_activity_record
 */
@Data
public class BizActivityRecordDto implements Serializable {

    private static final long serialVersionUID = 6496534093397014399L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动类型：1:一元购
     *
     * @see cn.com.duiba.oto.enums.activity.BizActivityTypeEnum
     */
    private String activityType;

    /**
     * 微信体系id：tb_oto_wx_users.id
     */
    private Long userId;

    /**
     * 额外参数
     *
     * @see BizActivityTypeEnum#getBeanClass()
     */
    private String recordParams;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}