package cn.com.duiba.oto.dto.oto.separate;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 留续审批详情表
 *
 * @TableName tb_oto_cust_separate_order
 */
@Data
public class CustSeparateOrderDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 销售id
     */
    private Long sellerId;
    /**
     * 客户id
     */
    private Long custId;
    /**
     * 剥离详情表id tb_oto_cust_separate.id
     */
    private Long separateId;
    /**
     * 申请理由
     */
    private String applyReason;
    /**
     * 跟进时长 天
     */
    private Integer followTime;
    /**
     * 申请时长
     */
    private Integer applyDay;
    /**
     * 审批时间
     */
    private Date approveTime;
    /**
     * 审批人id
     */
    private Long approverId;
    /**
     * 审批状态: 1:已同意 0:待审批 -1:已拒绝 2:已超时
     */
    private Integer approveStatus;
    /**
     * 审批意见
     */
    private String approveOpinion;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;

}