package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.sign.OtoCustSignRecordDto;
import cn.com.duiba.oto.dto.oto.activity.sign.OtoCustSignSellerDetailDto;
import cn.com.duiba.oto.dto.oto.activity.sign.SignDetailDto;
import cn.com.duiba.oto.dto.oto.activity.sign.SignSubmitDto;
import cn.com.duiba.oto.param.oto.activity.sign.SignComplementParam;
import cn.com.duiba.oto.param.oto.activity.sign.SignDetialParam;
import cn.com.duiba.oto.param.oto.activity.sign.SignSubmitParam;

import java.util.List;

/**
 * 功能描述：签到活动相关
 *
 * @Auther: xiaotian
 * @Date: 2023/1/30 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteActivitySignService {

    /**
     * 签到活动详情页
     *
     * @return 签到活动详情
     */
    SignDetailDto detail(SignDetialParam signDetialParam) throws BizException;

    /**
     * 活动签到
     *
     * @return 签到是否成功
     */
    SignSubmitDto submit(SignSubmitParam params) throws BizException;

    /**
     * 活动签到
     *
     * @return 签到是否成功
     */
    Boolean complement(SignComplementParam params) throws BizException;

    /**
     * 获取签到记录
     * @param activityIds
     * @return
     */
    List<OtoCustSignSellerDetailDto> getSignRecordList(List<Long> activityIds, List<Long> sellerIds);

    /**
     * 根据活动ID查询签到记录
     * @param activityId 活动ID
     */
    List<OtoCustSignSellerDetailDto> getSignRecordByActivityId(Long activityId);


    /**
     * 根据主键id查询
     * @param ids
     * @return
     */
    List<OtoCustSignRecordDto> selectByIds(List<Long> ids);
}
