package cn.com.duiba.oto.oto.service.api.remoteservice.log;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.CustCallLogCountBean;
import cn.com.duiba.oto.dto.oto.log.CustCallLogDto;
import cn.com.duiba.oto.param.oto.call.CallLogSearchParam;
import cn.com.duiba.oto.param.oto.log.OtoLogSearchParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-13 14:33
 */
@AdvancedFeignClient
public interface RemoteOtoCustCallLogService {

    /**
     * 获取最近正向拨号通话成功的通话记录
     * @param custId 客户id
     * @param otoSid 销售id
     * @return 通话记录
     */
    CustCallLogDto latestTakeSuccessLog(Long custId, Long otoSid);

    /**
     * 根据客户id和销售id以及时间查询日志（时间逆序）
     * @param param 查询参数
     * @return 日志列表
     */
    List<CustCallLogDto> listByCustIdAndTime(OtoLogSearchParam param);

    /**
     * 根据日志id判断有没有下一条
     * @param param 查询参数
     * @return 是否有下一条
     */
    boolean hasNext(OtoLogSearchParam param);

    /**
     * 保存客户通话日志
     *
     * @param custCallLogDto 客户通话日志
     * @return 保存结果
     */
    Long save(CustCallLogDto custCallLogDto) throws BizException;

    /**
     * 筛选通话记录小于指定时间的客户
     *
     * @param custIds 客户id
     * @param endDate 时间
     * @return 客户id
     */
    List<Long> searchLtCallTime(Long sellerId, List<Long> custIds, Date endDate);

    /**
     * 批量修复数据
     * @param callLogList 日志数据
     * @return 修复结果
     */
    boolean batchFix(List<CustCallLogDto> callLogList);

    /**
     * 根据客户id和销售id查询销售外呼记录
     * @param custIds 客户id
     * @param sellerId 销售id
     * @return 日志列表
     */
    List<CustCallLogDto> listSellerCallByCustIdAndSid(List<Long> custIds,Long sellerId);

    /**
     * 获取客户通话成功的通话记录
     * @return 通话记录
     */
    List<CustCallLogDto> latestTakeSuccessCallLog(List<Integer> callStatus);

    /**
     * 获取所有的接通电话记录电话记录（接通电话记录）
     *
     * @param custId 客户id
     * @param otoSid 销售id
     * @return 最近五次拨打电话记录
     */
    List<CustCallLogDto> listAllDealing(Long custId, Long otoSid);


    /**
     * 求客户被打电话的次数
     *
     * @param sellerId  销售id
     * @param custIds   客户id
     * @param beginDate 开始时间
     * @param endDate   结束时间
     * @return 客户被打电话的次数
     */
    List<CustCallLogCountBean> countCallLog(Long sellerId, List<Long> custIds, Date beginDate, Date endDate);

    /**
     * 求客户被打电话的次数
     * @param custIds   客户id
     * @return 客户被打电话的次数
     */
    List<CustCallLogDto> getCallByCustIds(List<Long> custIds);

    /**
     * 获取通话记录列表
     *
     * @param param
     * @return
     */
    PageResult<CustCallLogDto> searchCallLogList(CallLogSearchParam param);

}
