package cn.com.duiba.oto.oto.service.api.remoteservice.pet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.bean.pet.PetCapacityBean;
import cn.com.duiba.oto.dto.oto.pet.PetSchedulingItemDto;
import cn.com.duiba.oto.dto.oto.pet.staff.PetStaffSimpleDto;
import cn.com.duiba.oto.enums.pet.PetTimeSlotEnum;
import cn.com.duiba.oto.param.oto.pet.RemotePetAssignParam;
import cn.com.duiba.oto.param.oto.pet.RemotePetCapacityParam;
import cn.com.duiba.oto.param.oto.pet.RemotePetSchedulingSearchParam;
import javafx.util.Pair;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 宠物排班管理远程服务
 *
 * @author AI Assistant
 * @date 当前日期
 */
@AdvancedFeignClient
public interface RemotePetSchedulingService {

    /**
     * 搜索排班信息
     *
     * @param param
     * @return
     */
    List<PetSchedulingItemDto> searchSchedules(RemotePetSchedulingSearchParam param);

    /**
     * 获取所有员工信息
     *
     * @return
     */
    List<PetStaffSimpleDto> allStaffs();

    /**
     * 分配员工
     *
     * @param param
     * @return
     */
    boolean assignStaff(RemotePetAssignParam param) throws BizException;

    /**
     * 重新分配员工
     *
     * @param param
     * @return
     */
    boolean reAssign(RemotePetAssignParam param) throws BizException;

    /**
     * 更新员工容量
     *
     * @param param
     * @return
     */
    boolean updateCapacity(RemotePetCapacityParam param) throws BizException;


    /**
     * 获取可预约时间段的容量
     * @param dates
     * @return
     */
    Map<Date, Map<PetTimeSlotEnum, Pair<Integer, PetCapacityBean>>> getStaffCapacity(List<Date> dates);
}