package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 客户邀约记录表
 *
 * @author kjj mybatis generator
 * @date 2022-08-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustInvitationRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16595761519652762L;

    /**
     * 主键
     */
    private Long id;

    private List<Long> idList;

    /**
     * 面访地点（见面场景配置ID）
     */
    private Long interviewConfId;

    /**
     * 客户面访承诺时间
     */
    private Date interviewTime;

    /**
     * 本次面访客户总人数
     */
    private Integer custNum;

    /**
     * 是否就餐 0否 1是
     */
    private Integer haveMealFlag;

    /**
     * 是否接送 0否 1是
     */
    private Integer pickTakeFlag;

    /**
     * 接送地址
     */
    private String pickTakeAddress;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 邀约组销售ID
     */
    private Long inviteSellerId;

    /**
     * 带看组销售ID
     */
    private Long takeLookSellerId;

    /**
     * 专家对应的销售ID
     */
    private Long expertSellerId;

    /**
     * 分配状态 1待分配 2已分配 3超时未分配
     */
    private Integer assignStatus;

    /**
     * 客户是否已确认行程 1:待分配待确认 2:待分配已确认 3:待分配已鸽 4已分配预期到场 5已分配已到场 6已分配已鸽 7超期未分配
     */
    private Integer inviteStatus;

    /**
     * 是否实际分配过 0未分配 1已分配(区分预分配和实际已分配用)
     * @see cn.com.duiba.oto.enums.InvitationAssignFlagEnum
     */
    private Integer assignFlag;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否是最新的一条记录 0否 1是
     */
    private Integer newestFlag;

    /**
     * 此条数据的事件来源，枚举维护
     * @see cn.com.duiba.oto.enums.InvitationEventTypeEnum
     */
    private String eventType;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 一面还是二面 1一面 2二面
     */
    private Integer firstTwoInviteStatus;

    /**
     * 查询条件 承诺开始时间
     */
    private Date startTime;
    /**
     * 查询条件 承诺结束时间
     */
    private Date endTime;

    /**
     * 退回类型 默认为0，不退回，1：内情退回邀约组
     */
    private Integer returnBackType;

    /**
     * 接送时间
     */
    private Date receiveAndSendOffTime;

    /**
     * 组数
     */
    private Integer groupCount;

    /**
     * 备注
     */
    private String inviteRemark;
}