package cn.com.duiba.oto.param.oto.pay.response.wxpay;

import cn.com.duiba.oto.param.oto.pay.response.BaseChargeResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 微信公众号支付收单回执
 *
 * @author xiaotian
 * @date 2020/2/28 1:29 PM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class WxPayMpChargeResponse extends BaseChargeResponse {

    private static final long serialVersionUID = -5997227186919100960L;

    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;

    /**
     * 时间戳精确到秒
     */
    private Long timeStamp;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 公众号id
     */
    private String appId;

    /**
     * 签名类型需要和下单一致
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;
}
