package cn.com.duiba.oto.dto.oto.activity.invite;

import lombok.Data;

import java.io.Serializable;

/**
 * 邀请人记录表
 *
 * @author
 */
@Data
public class OtoInviterDetailDto implements Serializable {
    private static final long serialVersionUID = 1L;
    // 邀请人微信账户ID
    private Long inviterUserId;
    // 邀请人客户ID
    private Long inviterCustId;
    // 客户姓名：展示客户系统内的姓名
    private String inviterCustName;
    // 跟进专家：展示系统内当前跟进专家，若当前无跟进专家客户则显示“-”
    private String currentExpert;
    // 手机号（脱敏）：展示客户的手机号码，已进行脱敏处理
    private String maskedPhoneNumber;
    // 客户昵称：展示客户的系统内昵称
    private String customerNickname;
    // 邀请客户数：展示当前客户邀请总数，即成功邀请的新客户，符合年龄要求
    private int invitedCustomerCount = 0;
    // 下单客户数：展示当前客户邀请后下单的客户数
    private int orderedCustomerCount = 0;
    // 结单客户数：展示当前客户邀请成功后成功下单并完成的客户数
    private int completedOrderCustomerCount = 0;
    // 到场客户数：展示当前客户邀请成功后有到场记录的客户数
    private int attendedCustomerCount = 0;
    // 立减金获取数：统计当前客户累计邀请赠送的立减金数量
    private long totalReward = 0;
}