package cn.com.duiba.oto.dto.oto.cust.custImport.result;

import cn.com.duiba.oto.dto.oto.cust.custImport.param.CustImportBaseBean;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-29 10:51
 */
@Data
public class CustImportResultBean<T extends CustImportBaseBean> implements Serializable {

    private static final long serialVersionUID = -3055659269908789465L;

    /**
     * 传入的参数bean
     */
    private T bean;

    /**
     * 导入结果
     */
    private Boolean success;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 导入成功
     */
    public static <T extends CustImportBaseBean> CustImportResultBean<T> success(T bean, Long custId){
        CustImportResultBean<T> resultBean = new CustImportResultBean<>();
        resultBean.setBean(bean);
        resultBean.setCustId(custId);
        resultBean.setSuccess(true);
        return resultBean;
    }

    /**
     * 导入失败
     */
    public static <T extends CustImportBaseBean> CustImportResultBean<T> failed(T bean, String message, Long custId) {
        CustImportResultBean<T> resultBean = new CustImportResultBean<>();
        resultBean.setBean(bean);
        resultBean.setCustId(custId);
        resultBean.setErrorMsg(message);
        resultBean.setSuccess(false);
        return resultBean;
    }
}
