package cn.com.duiba.oto.dto.oto.live;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * tb_oto_live_clue
 *
 * @author
 */
@Data
public class OtoLiveClueDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 直播id
     */
    private String liveId;
    /**
     * 代理人id
     */
    private String agentId;
    /**
     * 线索id
     */
    private Long clueId;
    /**
     * oto客户id
     */
    private Long custId;
    /**
     * 客集集内部id
     */
    private String liveUserId;
    /**
     * 用户授权微信的昵称
     */
    private String nickName;
    /**
     * 用户授权微信的头像
     */
    private String avatar;
    /**
     * 授权手机号
     */
    private String authPhone;
    /**
     * 是否到场
     */
    private Integer present;
    /**
     * 1:直接邀请 0:好友裂变
     */
    private Integer directly;
    /**
     * 客户授权的地域信息
     */
    private String districtInfo;
    /**
     * 列表途径
     */
    private String inviteRouter;
    /**
     * 观看时长
     */
    private Integer duration;
    /**
     * 中奖信息
     */
    private String winPriceInfo;
    /**
     * 表单信息
     */
    private String submitFormInfo;
    /**
     * 投票信息
     */
    private String voteInfo;
    /**
     * 提问信息
     */
    private String askQuestionList;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 更新时间
     */
    private Date gmtModified;

    public List<SubmitFormInfo> getSubmitForm() {
        if (StringUtils.isEmpty(submitFormInfo)) {
            return Collections.emptyList();
        } else {
            return JSON.parseArray(submitFormInfo, SubmitFormInfo.class);
        }
    }

    public List<WinPriceInfo> getWinPrice() {
        if (StringUtils.isEmpty(winPriceInfo)) {
            return Collections.emptyList();
        } else {
            return JSON.parseArray(winPriceInfo, WinPriceInfo.class);
        }
    }

    @Data
    public static class SubmitFormInfo implements Serializable {

        private static final long serialVersionUID = 7729998662318368714L;

        private String materialId;

        private String formTitle;

        private String formImg;

        private String formData;
    }

    @Data
    public static class WinPriceInfo implements Serializable {

        private static final long serialVersionUID = -5259725249143984430L;

        private String prizeId;

        private String prizeName;

        private String prizeImg;

        private boolean specifyAward;
    }


}