package cn.com.duiba.oto.dto.oto.wx.wxmessage.customer;

import cn.com.duiba.oto.dto.oto.wx.wxmessage.BaseMessageDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * Created by xiaotian on 2020-02-06.
 * 公众号的小程序卡片消息
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CustomerMpCardDto extends BaseMessageDto {
    private static final long serialVersionUID = 3110615348476589318L;

    /**
     * 卡片标题
     */
    @NotBlank(message = "卡片标题不能为空")
    private String title;
    /**
     * 跳转目标小程序的app ID
     */
    @NotBlank(message = "卡片消息的小程序ID不能为空")
    private String appId;
    /**
     * 小程序的页面地址
     */
    @NotBlank(message = "小程序的页面地址不能为空")
    private String pagePath;
    /**
     * 小程序卡片的卡片地址
     */
    @NotBlank(message = "小程序卡片的图片地址不能为空")
    private String mediaId;
}
