package cn.com.duiba.oto.enums.crypto;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/11/4 10:27 AM
 */
public enum IdConverterLengthEnum {

    LOTTERY_LENGTH(12, "HB", "用户抽奖工具相关的主键加密，最大支持9位数的ID"),
    LOTTERY_ORDER_LENGTH(16, "HP", "用于抽奖工具订单的主键加密，最大支持13位数的ID"),
    ;

    private static final Map<String, IdConverterLengthEnum> ENUM_MAP = new HashMap<>();

    static {
        for (IdConverterLengthEnum lengthEnum : values()) {
            ENUM_MAP.put(lengthEnum.getCode(), lengthEnum);
        }
    }

    /**
     * 加密后的纯数字长度
     */
    private Integer length;
    /**
     * 加密后的位数标识，统一2个字母
     */
    private String code;
    private String desc;

    IdConverterLengthEnum(Integer length, String code, String desc) {
        this.length = length;
        this.code = code;
        this.desc = desc;
    }

    public static IdConverterLengthEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getLength() {
        return length;
    }

    public String getCode() {
        return CryptoTypeEnum.ID_CONVERTER.getCode() + code;
    }
}
