package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 宠物体型
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetGenderEnum {
    /**
     * 未知
     */
    UNKNOWN(0, "未知"),
    /**
     * 弟弟
     */
    MALE(1, "弟弟"),
    /**
     * 妹妹
     */
    FEMALE(2, "妹妹"),

    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetGenderEnum::getCode, PetGenderEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
