package cn.com.duiba.oto.oto.service.api.remoteservice.pet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.pet.RemoteOrderCreateResultDto;
import cn.com.duiba.oto.dto.oto.pet.RemoteOrderListItemDto;
import cn.com.duiba.oto.dto.oto.pet.RemoteOrderStatusStatisticsDto;
import cn.com.duiba.oto.dto.oto.pet.RemotePetOrderListItemDto;
import cn.com.duiba.oto.dto.oto.pet.WashServiceItemBasePriceDto;
import cn.com.duiba.oto.dto.oto.pet.WashServiceItemPriceDto;
import cn.com.duiba.oto.dto.oto.pet.order.PetOfflineOrdersDto;
import cn.com.duiba.oto.dto.oto.pet.order.RemoteOrderCalculateResultFeedDto;
import cn.com.duiba.oto.dto.oto.pet.order.RemoteOrderCalculateResultWashDto;
import cn.com.duiba.oto.dto.oto.pet.order.RemoteOrderDetailFeedDto;
import cn.com.duiba.oto.dto.oto.pet.order.RemoteOrderDetailWashDto;
import cn.com.duiba.oto.param.oto.pet.RemoteMatchPetDoctorParam;
import cn.com.duiba.oto.param.oto.pet.RemoteOrderDetailQueryParam;
import cn.com.duiba.oto.param.oto.pet.RemoteOrderListQueryParam;
import cn.com.duiba.oto.param.oto.pet.RemoteOrderRefundParam;
import cn.com.duiba.oto.param.oto.pet.RemotePetOfflineOrderSearchParam;
import cn.com.duiba.oto.param.oto.pet.RemotePetOrderCompleteParam;
import cn.com.duiba.oto.param.oto.pet.RemotePetOrderSearchParam;
import cn.com.duiba.oto.param.oto.pet.order.RemoteFeedOrderCreateParam;
import cn.com.duiba.oto.param.oto.pet.order.RemoteOrderCalculateFeedParam;
import cn.com.duiba.oto.param.oto.pet.order.RemoteOrderCalculateWashParam;
import cn.com.duiba.oto.param.oto.pet.order.RemotePetWashOrderUpdateParam;
import cn.com.duiba.oto.param.oto.pet.order.RemoteWashOrderCreateParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * 宠物订单相关
 *
 * @author xiaotian
 * @date 2025/4/14 2:15 PM
 *
 **/
@AdvancedFeignClient
public interface RemotePetOrderService {

    /**------------------------------------------------小程序通用接口-----------------------------------------------**/

    /**
     * 我的订单列表（分页+状态筛选）
     * @param param
     * @return
     */
    PageResult<RemoteOrderListItemDto> getOrderList(RemoteOrderListQueryParam param);

    /**
     * 获取订单状态
     * @param orderId
     * @return
     */
    Integer getOrderStatus(Long orderId);

    /**
     * 申请退款
     */
    Boolean applyRefund(RemoteOrderDetailQueryParam param) throws BizException;

    /**
     * 订单统计
     *
     * @return
     */
    List<RemoteOrderStatusStatisticsDto> getOrderStatistics(Long userId);

    /**--------------------------------------------------宠物喂养-------------------------------------------------**/

    /**
     * 喂养订单详情
     * @param param
     * @return
     */
    RemoteOrderDetailFeedDto getFeedOrderDetail(RemoteOrderDetailQueryParam param);

    /**
     * 计算喂养订单金额（主+子订单）
     * @param param
     * @return
     * @throws BizException
     */
    RemoteOrderCalculateResultFeedDto calculateFeedOrderAmount(RemoteOrderCalculateFeedParam param) throws BizException;

    /**
     * 新增喂养预约单
     * @param param
     * @return
     * @throws BizException
     */
    RemoteOrderCreateResultDto createFeedOrder(RemoteFeedOrderCreateParam param) throws BizException;

    /**--------------------------------------------------宠物洗护-------------------------------------------------**/

    /**
     * 洗护订单详情
     * @param param
     * @return
     */
    RemoteOrderDetailWashDto getWashOrderDetail(RemoteOrderDetailQueryParam param);

    /**
     * 计算洗护订单金额（主+子订单）
     * @param param
     * @return
     * @throws BizException
     */
    RemoteOrderCalculateResultWashDto calculateWashOrderAmount(RemoteOrderCalculateWashParam param) throws BizException;

    /**
     *  新增洗护预约单
     * @param param
     * @return
     * @throws BizException
     */
    RemoteOrderCreateResultDto createWashOrder(RemoteWashOrderCreateParam param) throws BizException;

    /**
     * 根据宠物id获取洗护服务基础价格
     * @param petId
     * @return
     */
    WashServiceItemBasePriceDto washServiceItemBasePriceByPetId(Long userId, Long petId) throws BizException;

    /**
     * 获取洗护服务价格
     * @return
     */
    List<WashServiceItemPriceDto> washServiceItemPrice();


    /**----------------------------------------------------crm--------------------------------------------------------**/

    /**
     * 订单列表搜索（分页）
     */
    PageResult<RemotePetOrderListItemDto> searchOrders(RemotePetOrderSearchParam param);


    /**
     * 标记订单完成
     */
    Boolean markOrderComplete(RemotePetOrderCompleteParam param);

    /**
     * 审核退款
     */
    Boolean auditRefund(RemoteOrderRefundParam param) throws BizException;

    /**
     * 匹配宠托师
     */
    Boolean matchPetDoctor(RemoteMatchPetDoctorParam remoteMatchPetDoctorParam) throws BizException;

    /**
     * 更新线上订单（备注和预约时间）
     */
    Boolean updateOnlineOrder(RemotePetWashOrderUpdateParam param) throws BizException;


    /**----------------------------------------------------线下订单--------------------------------------------------------**/


    /**
     * 订单列表搜索（分页）
     */
    PageResult<RemotePetOrderListItemDto> searchOfflineOrders(RemotePetOfflineOrderSearchParam param);

    /**
     * 新增更新线下订单
     */
    Long insertUpdateOfflineOrder(PetOfflineOrdersDto petOfflineOrdersDto) throws BizException;

    /**
     * 获取线下订单
     */
    PetOfflineOrdersDto getOfflineOrder(Long id);

    /**
     * 删除线下订单
     */
    Boolean deleteOfflineOrder(Long id);

    /**
     * 标记线下订单完成
     */
    Boolean markOfflineOrderComplete(RemotePetOrderCompleteParam param) throws BizException;

}
