package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 业务信息操作日志表
 * @author kjj mybatis generator 
 * @date 2023-03-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class BusinessOptLogSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16787635666757210L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 操作人id oto_seller.id
     */
    private Long operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 操作类型 0系统操作 1人为操作
     */
    private Integer optType;

    /**
     * 操作场景
     */
    private Integer optScene;

    /**
     * 轨迹id
     */
    private String traceId;

    /**
     * 操作key
     */
    private String optKey;

    /**
     * 老操作value
     */
    private String oldOptValue;

    /**
     * 新操作value
     */
    private String newOptValue;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}