/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust.form;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LibraryStatusEnum {
    DEL(-1, "\u5220\u9664"),
    CLOSE(0, "\u505c\u7528"),
    WAIT(1, "\u5f85\u53d1\u5e03"),
    PUBLISH(2, "\u4f7f\u7528\u4e2d");

    private static final Map<Integer, LibraryStatusEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private LibraryStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static LibraryStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(LibraryStatusEnum.values()).collect(Collectors.toMap(LibraryStatusEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

