package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Data
public class SellerBoardDto implements Serializable {
    private static final long serialVersionUID = 4011617160188918337L;

    /**
     * 数据总揽
     */
    private StatisticsDto allVo;

    /**
     * 销售统计列表
     */
    private List<SellerStatisticsDto> sellerStatisticsVos;


    public static SellerBoardDto init() {
        SellerBoardDto sellerBoardDto = new SellerBoardDto();
        sellerBoardDto.setAllVo(new StatisticsDto());
        sellerBoardDto.setSellerStatisticsVos(new ArrayList<>());
        return sellerBoardDto;
    }


    @Data
    public static class StatisticsDto implements Serializable {

        private static final long serialVersionUID = -7459810728782907329L;

        /**
         * 客户总数
         */
        private Integer custCount = 0;

        /**
         * 两周内面访客户
         */
        private Integer interviewCustCount = 0;

        /**
         * 脱落预警客户
         */
        private Integer warnCustCount = 0;

        /**
         * 星标客户
         */
        private Integer starCustCount = 0;

        /**
         * 社区高客
         */
        private Integer communityStarCount = 0;

        /**
         * 成单客户
         */
        private Integer dealCustCount = 0;

        /**
         * 转介绍客户
         */
        private Integer introduceCustCount = 0;

    }


    @Data
    public static class SellerStatisticsDto implements Serializable {

        private static final long serialVersionUID = -7459810728782907329L;

        private Long sellerId;

        private String sellerName;

        private StatisticsDto sellerStatisticsVo;
    }
}
