package cn.com.duiba.oto.dto.oto.oa;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户报告审批表
 * @author kjj mybatis generator 
 * @date 2023-03-25
 */
@Data
public class OtoCustReportOaDto implements Serializable {
     
    private static final long serialVersionUID = 16797088382522018L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 客户id tb_oto_cust表主键id
     */
    private Long custId;

    /**
     * 提交报告的专家/销售ID
     */
    private Long createId;

    /**
     * 提交报告人的当下角色
     */
    private Integer createRoleType;

    /**
     * 审批状态 1:待审批 2:审批通过 3:审批驳回 4:已上传方案
     */
    private Integer auditStatus;

    /**
     * 下一阶段待审批角色
     */
    private Integer nextRoleType;

    /**
     * 下一阶段待审批角色类型
     */
    private Integer nextRoleTypeOrder;

    /**
     * 下一阶段审批角色是否从未审批过 0否 1是
     */
    private Integer nextRoleTypeHasAudit;

    /**
     * 是否是当前客户最新的审批数据 0否 1是
     */
    private Integer newestRecord;

    /**
     * 期望交付时间
     */
    private Date hopePayTime;

    /**
     * 备注
     */
    private String submitRecord;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}