package cn.com.duiba.oto.dto.oto.wx.place;

import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * 功能描述：微信位置搜索结果封装类
 * 该类用于接收并解析微信位置搜索接口返回的数据结构，
 * 包括搜索结果列表、分页信息、请求状态等字段。
 * 可广泛应用于地理位置相关的业务逻辑处理。
 *
 * @Auther: xiaotian
 * @Date: 2025/5/13 15:21
 * @Description:
 */
@Data
public class WxPlaceSearchResultDto implements Serializable {
    private static final long serialVersionUID = -4317561038941296916L;
    /**
     * 总数据条目数量
     * 示例值：1989
     */
    private int count;

    /**
     * 请求响应消息
     * 示例值："Success"
     */
    private String message;

    /**
     * 请求唯一标识符，用于追踪请求日志
     * 示例值："2d9018e65f64df2be769fbd193848ebc"
     */
    private String requestId;

    /**
     * 请求处理状态码
     * 示例值：0（表示成功）
     */
    private int status;

    /**
     * 搜索结果数据列表，包含多个地点信息
     * 每个 Data 对象代表一个地点详情
     */
    private List<WxPlaceSearchResultData> data;

    /**
     * 内部类：Data
     * 表示单个地点的详细信息
     */
    @Data
    public static class WxPlaceSearchResultData implements Serializable {
        private static final long serialVersionUID = -7045110789692246993L;
        /**
         * 当前地点与搜索坐标的距离（单位：米）
         * 示例值：0.0 或 2.0
         */
        private double distance;

        /**
         * 地点的详细地址信息
         * 示例值："江西省南昌市东湖区大院街道二七北路98号b107-1室"
         */
        private String address;

        /**
         * 地理行政区划信息，包括省市区及编码
         *
         * @see AdInfo
         */
        private AdInfo adInfo;

        /**
         * 地点联系电话
         * 示例值："19924395934" 或空字符串
         */
        private String tel;

        /**
         * 地理坐标经纬度信息
         *
         * @see Location
         */
        private Location location;

        /**
         * 地点唯一标识符
         * 示例值："12134460711942916536"
         */
        private String id;

        /**
         * 地点名称或标题
         * 示例值："千花伴购物公园(二七北路店)"
         */
        private String title;

        /**
         * 地点分类信息
         * 示例值："购物:花鸟鱼虫"
         */
        private String category;
    }

    /**
     * 内部类：AdInfo
     * 表示地理区域划分信息，如省份、城市、区县及对应的行政编码
     */
    @Data
    public static class AdInfo implements Serializable {
        private static final long serialVersionUID = 4244556538186959725L;
        /**
         * 省份名称
         * 示例值："江西省"
         */
        private String province;

        /**
         * 行政区划编码
         * 示例值：360102
         */
        private int adcode;

        /**
         * 城市名称
         * 示例值："南昌市"
         */
        private String city;

        /**
         * 区县名称
         * 示例值："东湖区"
         */
        private String district;

    }

    /**
     * 内部类：Location
     * 表示某个地点的经纬度坐标
     */
    @Data
    public static class Location implements Serializable {
        private static final long serialVersionUID = -797811774821523009L;
        /**
         * 经度值
         * 示例值：115.918377
         */
        private double lng;

        /**
         * 纬度值
         * 示例值：28.681114
         */
        private double lat;
    }

}
