package cn.com.duiba.oto.oto.service.api.remoteservice.goods;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.goods.GoodsBuyDetail;
import cn.com.duiba.oto.dto.oto.goods.GoodsDetail;
import cn.com.duiba.oto.dto.oto.goods.GoodsDto;
import cn.com.duiba.oto.dto.oto.goods.WebGoodsDetail;
import cn.com.duiba.oto.param.oto.goods.RemoteGoodsTurnParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSaveOrUpdateGoodsParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSearchBatchParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSearchGoodsParam;
import cn.com.duiba.oto.param.oto.goods.RemoteSearchParam;
import cn.com.duiba.oto.param.oto.goods.RemoteWebSearchParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * @Author huliangsheng
 * @Date 2024/8/12 17:33
 */
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 商品列表
     */
    PageResult<GoodsDto> list(RemoteSearchGoodsParam param);

    /**
     * C端商品列表
     */
    PageResult<GoodsDto> webList(RemoteWebSearchParam param);

    /**
     * 新增商品
     */
    Boolean saveGoods(RemoteSaveOrUpdateGoodsParam param) throws BizException;

    /**
     * 编辑商品
     */
    Boolean updateGoods(RemoteSaveOrUpdateGoodsParam param) throws BizException;

    /**
     * 上架/下架
     */
    Boolean updateGoodsSaleStatus(RemoteGoodsTurnParam param) throws BizException;

    /**
     * 商品详情
     */
    GoodsDetail goodsDetail(Long id) throws BizException;

    /**
     * 商品详情(C端）
     */
    WebGoodsDetail goodsDetail4Web(RemoteSearchParam param) throws BizException;

    /**
     * 批量商品购买详情(C端）
     */
    List<GoodsBuyDetail> goodsBuyDetail(RemoteSearchBatchParam param);

    /**
     * 标记是否有真实库存
     *
     * @param goodsId 商品ID
     * @return
     */
    boolean switchActualStocks(Long goodsId, Integer actualStocks);

}
