package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.checkin.CheckInRecordDto;
import cn.com.duiba.oto.param.oto.seller.CheckInRecordQueryParam;
import cn.com.duiba.oto.util.PageResult;

@AdvancedFeignClient
public interface RemoteSellerCheckInService {

    /**
     * 物业专员打卡
     */
    Long checkIn(CheckInRecordDto checkInRecordDto) throws BizException;


    /**
     * 更新物业专员打卡记录
     */
    Boolean updateCheckInRecord(CheckInRecordDto checkInRecordDto) throws BizException;


    /**
     * 删除物业专员打卡记录
     */
    Boolean deleteCheckInRecord(Long id) throws BizException;


    /**
     * 物业专员打卡记录查询（mng）
     *
     * @param queryParam
     * @return
     */
    PageResult<CheckInRecordDto> queryCheckInRecord(CheckInRecordQueryParam queryParam);

}
