package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * kyc客户关联表
 * @author kjj mybatis generator 
 * @date 2023-01-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustKycSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16733447983527835L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 客户id tb_oto_customer.id
     */
    private Long custId;

    /**
     * 操作人
     */
    private Long operatorId;

    /**
     * kyc图片地址
     */
    private String kycImage;

    /**
     * 方案地址
     */
    private String planFile;

    /**
     * kyc最后一次上传时间
     */
    private Date kycUploadTime;

    /**
     * 方案最后一次上传时间
     */
    private Date planUploadTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}