package cn.com.duiba.oto.param.oto.pet.channel;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
public class RemotePetChannelSearchParam extends PageQuery {
    private static final long serialVersionUID = -5916255288347569240L;
    // 物业名称
    private String propertyName;
    // 小区名称
    private String communityName;
    // BD负责人
    private String bdLeader;
    // 渠道状态 (0-已停用, 1-已启用)
    private Integer channelStatus;
    // 结算方式 (1-物业结算, 2-小区结算)
    private Integer settlementMethod;
    // 开始时间
    private Date startTime;
    // 结束时间
    private Date endTime;
    //是否需要统计数据
    private Boolean needStatistics = false;
}