/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.oa;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum OaAuditStatusEnum {
    WAIT_AUDIT(1, "\u5f85\u5ba1\u6279"),
    AUDIT_SUCCESS(2, "\u5df2\u901a\u8fc7"),
    AUDIT_REFUSED(3, "\u5df2\u9a73\u56de"),
    UPLOAD_PLAN(4, "\u5df2\u4e0a\u4f20\u65b9\u6848");

    private Integer code;
    private String desc;
    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private OaAuditStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(OaAuditStatusEnum.values()).collect(Collectors.toMap(OaAuditStatusEnum::getCode, OaAuditStatusEnum::getDesc, (v1, v2) -> v1)));
    }
}

