/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Date;

public class OtoDateUtil {
    public static final String PATTERN_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_DATE = "yyyy-MM-dd";
    public static final String PATTERN_COMPACT = "yyyyMMddHHmmss";
    public static final String DAY_NUMBER = "yyyyMMdd";
    public static final String YEAR_DAY_NUMBER = "yyMMdd";
    public static final String YEAR = "yyyy";
    public static final String DAY_ONLY = "MM-dd";
    public static final String SECOND_ONLY = "HH:mm:ss";
    public static final String MINUTE = "yyyy-MM-dd HH:mm";
    public static final String MINUTE_ONLY = "HH:mm";
    public static final String MONTH_DAY_YEAR = "MM/dd/yyyy";
    public static final String MILLI_SECOND = "yyyyMMddHHmmssSSS";

    public static String format(LocalDateTime dateTime) {
        return OtoDateUtil.format(dateTime, PATTERN_DEFAULT);
    }

    public static String format(LocalDateTime dateTime, String pattern) {
        return dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parse(String dateStr, String pattern) {
        return LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate parseLocalDate(String dateStr, String pattern) {
        return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String getCurrentTimeString() {
        return OtoDateUtil.format(LocalDateTime.now());
    }

    public static LocalDate dateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDateToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime plus(LocalDateTime dateTime, long amount, TemporalUnit unit) {
        return dateTime.plus(amount, unit);
    }

    public static LocalDateTime minus(LocalDateTime dateTime, long amount, TemporalUnit unit) {
        return dateTime.minus(amount, unit);
    }

    public static long between(LocalDateTime start, LocalDateTime end, TemporalUnit unit) {
        return unit.between(start, end);
    }

    public static boolean isBefore(LocalDateTime dateTime, LocalDateTime compareTo) {
        return dateTime.isBefore(compareTo);
    }

    public static boolean isAfter(LocalDateTime dateTime, LocalDateTime compareTo) {
        return dateTime.isAfter(compareTo);
    }

    public static LocalDateTime getDayStart(LocalDateTime dateTime) {
        return dateTime.toLocalDate().atStartOfDay();
    }

    public static LocalDateTime getDayEnd(LocalDateTime dateTime) {
        return dateTime.toLocalDate().atTime(LocalTime.MAX);
    }

    public static LocalDateTime getFirstDayOfMonth(LocalDateTime dateTime) {
        return dateTime.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime getLastDayOfMonth(LocalDateTime dateTime) {
        return dateTime.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return date1.toLocalDate().equals(date2.toLocalDate());
    }

    public static LocalDateTime convertZone(LocalDateTime dateTime, ZoneId fromZone, ZoneId toZone) {
        return dateTime.atZone(fromZone).withZoneSameInstant(toZone).toLocalDateTime();
    }

    public static int calculateAge(LocalDate birthDate) {
        return Period.between(birthDate, LocalDate.now()).getYears();
    }

    public static LocalDateTime getStartOfWeek(LocalDateTime dateTime) {
        return dateTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).toLocalDate().atStartOfDay();
    }

    public static LocalDateTime getEndOfWeek(LocalDateTime dateTime) {
        return dateTime.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).toLocalDate().atTime(LocalTime.MAX);
    }
}

