/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CustLevelTypeEnum {
    NORMAL(1, "\u666e\u5361"),
    SILVER(2, "\u94f6\u5361"),
    METALS(3, "\u91d1\u5361"),
    PLATINUM(4, "\u94c2\u91d1\u5361"),
    DIAMOND(5, "\u94bb\u77f3\u5361"),
    BLACK_DIAMOND(6, "\u9ed1\u94bb\u5361");

    private Integer code;
    private String desc;
    private static final Map<Integer, String> TYPE_MAP;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static CustLevelTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(CustLevelTypeEnum.values()).filter(assignRoleTypeEnum -> assignRoleTypeEnum.getCode().equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private CustLevelTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(CustLevelTypeEnum.values()).collect(Collectors.toMap(CustLevelTypeEnum::getCode, CustLevelTypeEnum::getDesc, (v1, v2) -> v1)));
    }
}

