/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.deal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PaymentMethodEnum {
    YEAR(1, "\u5e74\u4ea4"),
    MONTH(2, "\u6708\u4ea4"),
    QUARTER(3, "\u5b63\u5ea6\u4ea4");

    private static final Map<Integer, PaymentMethodEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private PaymentMethodEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PaymentMethodEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(PaymentMethodEnum.values()).collect(Collectors.toMap(PaymentMethodEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

