/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.form;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum RecordLabelEnum {
    OTHER(-1, "\u5176\u4ed6"),
    NOT(0, "\u6682\u65e0"),
    VALID(1, "\u6709\u6548"),
    INVALID(2, "\u65e0\u6548\u7684");

    private final Integer code;
    private final String description;
    public static final Map<Integer, RecordLabelEnum> LABEL_MAP;

    public static RecordLabelEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return INVALID;
        }
        return LABEL_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private RecordLabelEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    static {
        Map map = Arrays.stream(RecordLabelEnum.values()).collect(Collectors.toMap(RecordLabelEnum::getCode, Function.identity()));
        LABEL_MAP = Collections.unmodifiableMap(map);
    }
}

