/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.deal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DealTypeEnum {
    NORMAL(1, "\u6b63\u5e38\u5355"),
    ORPHAN(2, "\u5b64\u513f\u5355");

    private static final Map<Integer, DealTypeEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private DealTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DealTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        DealTypeEnum type = INNER_MAP.get(code);
        return type == null ? null : type.getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(DealTypeEnum.values()).collect(Collectors.toMap(DealTypeEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

