/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetWashTypeEnum {
    COMPETITION_WASH(0, 0L, 0, "https://yun.kjjcrm.com/kjy/media/file/20251118/file-20251118143619257-KCB.png?x-oss-process=image/quality,q_80", "\u8d5b\u7ea7\u6d17\u62a4"),
    BASIC_WASH(1, 0L, 0, "https://yun.kjjcrm.com/kjy/media/file/20251118/file-20251118143619257-jZF.png?x-oss-process=image/quality,q_80", "\u57fa\u7840\u6d17\u62a4"),
    OPEN_JOINT(2, 5000L, 1, "https://yun.tuisnake.com/jjb-pet-weapp/202506/pcepaei4owbmedevizacz.png", "\u5f00\u7ed3"),
    LOCAL_DEOILING(3, 5000L, 2, "https://yun.tuisnake.com/jjb-pet-weapp/202506/xgy4g8id2osdeawf3daj4.png", "\u5c40\u90e8\u53bb\u6cb9"),
    MEDICATED_BATH(4, 8000L, 3, "https://yun.tuisnake.com/jjb-pet-weapp/202506/qtdyggzxbd7d6zzr_vj4c.png", "\u836f\u6d74"),
    WHOLE_BODY_DEOILING(5, 10000L, 4, "https://yun.tuisnake.com/jjb-pet-weapp/202506/ogdkmzbwtpfirdstxyk53.png", "\u5168\u8eab\u53bb\u6cb9"),
    BRUSH_TEETH(6, 2000L, 5, "https://yun.tuisnake.com/jjb-pet-weapp/202506/jktbvuxnenojszw1wt5s7.png", "\u5237\u7259"),
    LOCAL_BARBERING(7, 3000L, 6, "https://yun.tuisnake.com/jjb-pet-weapp/202506/xtimwvqjmcrobwlw_rpbz.png", "\u5c40\u90e8\u5243\u6bdb"),
    LOW_PRICE_SHAVING(9, 2000L, 7, "https://yun.tuisnake.com/jjb-pet-weapp/202506/yvuegjcpkfunpf7e1kjq6.png", "\u8d35\u5bbe\u811a"),
    WHOLE_BODY_SHAVING(8, 12000L, 8, "https://yun.tuisnake.com/jjb-pet-weapp/202506/pa-xozu0qtx-xwxo3eikn.png", "\u5168\u8eab\u5243\u6bdb"),
    WHOLE_BODY_BARBERING(9, 8000L, 9, "https://yun.tuisnake.com/jjb-pet-weapp/202506/-qp7ls4ah_fpcrvmt63om.png", "\u6df1\u5ea6\u9664\u6bdb");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private static final Map<Integer, Long> CUSTOMER_PRICE_MAP;
    private Integer code;
    private Long price;
    private Integer order;
    private String icon;
    private String desc;

    public Long getPrice() {
        if (SpringEnvironmentUtils.isProdEnv()) {
            return this.price;
        }
        return this.price / 1000L;
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public static Long getPriceByCode(Integer code) {
        if (code == null) {
            return 0L;
        }
        return CUSTOMER_PRICE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetWashTypeEnum(Integer code, Long price, Integer order, String icon, String desc) {
        this.code = code;
        this.price = price;
        this.order = order;
        this.icon = icon;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetWashTypeEnum.values()).collect(Collectors.toMap(PetWashTypeEnum::getCode, PetWashTypeEnum::getDesc, (v1, v2) -> v1)));
        CUSTOMER_PRICE_MAP = Collections.unmodifiableMap(Arrays.stream(PetWashTypeEnum.values()).collect(Collectors.toMap(PetWashTypeEnum::getCode, PetWashTypeEnum::getPrice, (v1, v2) -> v1)));
    }
}

