/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.constant.ActionTypes;
import cn.com.duiba.paycenter.params.PayOrdersExtraParams;
import cn.com.duiba.paycenter.result.PayOrdersResult;
import cn.com.duiba.paycenter.service.PayOrdersService;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;

public class PayOrdersServiceClient {
    private PayOrdersService payOrdersService;

    public RpcResult<PayOrdersResult> payOrder(Long developerId, Long orderId, Long money, PayOrdersExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.payOrdersService.payOrder(developerId, orderId, money, sign, p);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }

    public RpcResult<PayOrdersResult> backpayOrder(Long developerId, Long orderId, Long money, PayOrdersExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("orderId", orderId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayOrdersResult ret = this.payOrdersService.backpayOrder(developerId, orderId, money, sign, p);
            return new RpcResult<PayOrdersResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayOrdersResult>(e);
        }
    }

    public RpcResult<Boolean> checkActionSuccess(Long orderId, ActionTypes.OrdersActionType actionType) {
        try {
            boolean ret = this.payOrdersService.checkActionSuccess(orderId, actionType.getKey());
            return new RpcResult<Boolean>(ret);
        }
        catch (Exception e) {
            return new RpcResult<Boolean>(e);
        }
    }

    public void setPayOrdersService(PayOrdersService payOrdersService) {
        this.payOrdersService = payOrdersService;
    }
}

