/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.model.AccountChangeRecordDO;
import cn.com.duiba.paycenter.model.DuibaAccountChangeRecordDO;
import cn.com.duiba.paycenter.service.PayCenterService;
import java.util.List;

public class PayCenterServiceClient {
    private PayCenterService payCenterService;

    public RpcResult<Long> getBalance(Long developerId) {
        try {
            Long balance = this.payCenterService.getBalance(developerId);
            return new RpcResult<Long>(balance);
        }
        catch (Exception e) {
            return new RpcResult<Long>(e);
        }
    }

    public RpcResult<Long> getDuibaBalance() {
        try {
            Long balance = this.payCenterService.getDuibaBalance();
            return new RpcResult<Long>(balance);
        }
        catch (Exception e) {
            return new RpcResult<Long>(e);
        }
    }

    public RpcResult<List<AccountChangeRecordDO>> find(String relationType, Long relationId) {
        try {
            List<AccountChangeRecordDO> list = this.payCenterService.find(relationType, relationId);
            return new RpcResult<List<AccountChangeRecordDO>>(list);
        }
        catch (Exception e) {
            return new RpcResult<List<AccountChangeRecordDO>>(e);
        }
    }

    public RpcResult<List<DuibaAccountChangeRecordDO>> findDuibaRecords(String relationType, Long relationId) {
        try {
            List<DuibaAccountChangeRecordDO> list = this.payCenterService.findDuibaRecords(relationType, relationId);
            return new RpcResult<List<DuibaAccountChangeRecordDO>>(list);
        }
        catch (Exception e) {
            return new RpcResult<List<DuibaAccountChangeRecordDO>>(e);
        }
    }

    public RpcResult<List<AccountChangeRecordDO>> findAllGreaterId(Long lastId, int batchSize) {
        try {
            List<AccountChangeRecordDO> list = this.payCenterService.findAllGreaterId(lastId, batchSize);
            return new RpcResult<List<AccountChangeRecordDO>>(list);
        }
        catch (Exception e) {
            return new RpcResult<List<AccountChangeRecordDO>>(e);
        }
    }

    public RpcResult<List<DuibaAccountChangeRecordDO>> findAllDuibaGreaterId(Long lastId, int batchSize) {
        try {
            List<DuibaAccountChangeRecordDO> list = this.payCenterService.findAllDuibaGreaterId(lastId, batchSize);
            return new RpcResult<List<DuibaAccountChangeRecordDO>>(list);
        }
        catch (Exception e) {
            return new RpcResult<List<DuibaAccountChangeRecordDO>>(e);
        }
    }

    public void setPayCenterService(PayCenterService payCenterService) {
        this.payCenterService = payCenterService;
    }
}

