package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.params.AppAccountChangeParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppMarkAccountService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 开发者应用标记账户
 * author zhanghuifeng
 * date 2018/11/20-11:00 AM
 */
public class AppMarkAccountServiceClient {

    @Resource
    private RemoteAppMarkAccountService remoteAppMarkAccountService;

    /**
     * 账户扣款接口
     * @param param
     * @return
     */
    public RpcResult<PayCenterResult> reduceMoney(AppAccountChangeParams param){
        try {
            Map<String, String> params=new HashMap<>();
            params.put("developerId", param.getDeveloperId()+"");
            params.put("relationId", param.getRelationId()+"");
            params.put("money", param.getMoney()+"");
            params.put("appId",param.getAppId()+"");
            String sign = SignUtil.sign(params);
            PayCenterResult ret = remoteAppMarkAccountService.reduceMoney(param,sign);

            return new RpcResult<>(ret);
        } catch (Exception e) {
            return new RpcResult<>(e);
        }
    }

    /**
     * 账户发生回款接口
     * @param param
     * @return
     */
    public RpcResult<PayCenterResult> addMoney(AppAccountChangeParams param){
        try {
            Map<String, String> params=new HashMap<>();
            params.put("developerId", param.getDeveloperId()+"");
            params.put("relationId", param.getRelationId()+"");
            params.put("money", param.getMoney()+"");
            params.put("appId",param.getAppId()+"");
            String sign = SignUtil.sign(params);
            PayCenterResult ret = remoteAppMarkAccountService.addMoney(param,sign);
            return new RpcResult<>(ret);
        } catch (Exception e) {
            return new RpcResult<>(e);
        }
    }
}
