package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.params.AppAccountPayChargeParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppAccountPayChargeService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 开发者账户人工、在线充值
 * author zhanghuifeng
 * date 2018/11/6-11:57 AM
 */
public class AppPayChargeServiceClient {

    private static final String DEVELOPER_ID = "developerId";
    private static final String RELATION_ID = "relationId";
    private static final String MONEY = "money";
    private static final String APP_ID = "appId";
    @Resource
    private RemoteAppAccountPayChargeService remoteAppAccountPayChargeService;
    /**
     * 人工充值
     * @param payChargeParams
     * @return
     */
    public RpcResult<PayCenterResult> chargeMoneyByManual(AppAccountPayChargeParams payChargeParams){
        try {
            Map<String, String> params=new HashMap<>();
            params.put(DEVELOPER_ID, payChargeParams.getDeveloperId()+"");
            params.put(RELATION_ID, payChargeParams.getRelationId()+"");
            params.put(MONEY, payChargeParams.getChangeMoney()+"");
            params.put(APP_ID,payChargeParams.getAppId()+"");
            String sign= SignUtil.sign(params);

            PayCenterResult ret= remoteAppAccountPayChargeService.chargeMoneyByManual(payChargeParams,sign);

            return new RpcResult<>(ret);
        } catch (Exception e) {
            return new RpcResult<>(e);
        }
    }
    /**
     * 在线充值
     * @param params
     * @return
     */
    public RpcResult<PayCenterResult> chargeMoneyByOnline(AppAccountPayChargeParams params){
        try {
            String sign=getSign(params.getDeveloperId(), params.getAppId(), params.getRelationId(), params.getChangeMoney());


            PayCenterResult ret=remoteAppAccountPayChargeService.chargeMoneyByOnline(params,sign);

            return new RpcResult<>(ret);
        } catch (Exception e){
            return new RpcResult<>(e);
        }
    }
    /**
     * 当充值错误，需要减钱时，调用此方法
     * 正常情况不会使用此方法
     * @param payChargeParams
     * @return
     */
    public RpcResult<PayCenterResult> reduceMoneyByManual(AppAccountPayChargeParams payChargeParams){
        try {
            Map<String, String> params=new HashMap<>();
            params.put(DEVELOPER_ID, payChargeParams.getDeveloperId()+"");
            params.put(RELATION_ID, payChargeParams.getRelationId()+"");
            params.put(MONEY, payChargeParams.getChangeMoney()+"");
            params.put(APP_ID,payChargeParams.getAppId()+"");
            String sign=SignUtil.sign(params);

            PayCenterResult ret = remoteAppAccountPayChargeService.reduceMoneyByManual(payChargeParams,sign);

            return new RpcResult<>(ret);
        } catch (Exception e){
            return new RpcResult<>(e);
        }
    }

    /**
     * 在线充值手续费
     * @param payChargeParams
     * @return
     */
    public RpcResult<PayCenterResult> chargeMoneyFeeByOnline(AppAccountPayChargeParams payChargeParams){
        try {
            String sign=getSign(payChargeParams.getDeveloperId(), payChargeParams.getAppId(), payChargeParams.getRelationId(), payChargeParams.getChangeMoney());

            PayCenterResult ret = remoteAppAccountPayChargeService.chargeMoneyFeeByOnline(payChargeParams,sign);

            return new RpcResult<>(ret);
        } catch (Exception e){
            return new RpcResult<>(e);
        }
    }

    private String getSign(Long developerId,Long appId,String onlineApplyId,Long money){
        Map<String, String> params=new HashMap<>();
        params.put(DEVELOPER_ID, developerId+"");
        params.put(RELATION_ID, onlineApplyId+"");
        params.put(MONEY, money+"");
        params.put(APP_ID,appId+"");
        return SignUtil.sign(params);
    }
}
