package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @program: pay-center
 * @description: 招商银行一网通支付请求
 * @author: Simba
 * @create: 2019-09-26 14:20
 **/
public class CmbOneNetPayRequest extends BaseChargeRequest {
//    private static final long serialVersionUID = -7697113004354918338L;
//    /**
//     * 接口版本号
//     * 固定为“1.0”
//     */
//    @NotNull(message = "接口版本号不能为空")
//    @Size(max = 3, message = "接口版本号长度超过3")
//    private String version;
//
//    /**
//     * 参数编码
//     * 固定为“UTF-8”（默认）
//     */
//    @NotNull(message = "参数编码不能为空")
//    @Size(max = 8, message = "参数编码长度超过8")
//    private String charset;
//
//    /**
//     * 报文签名
//     * 使用支付密钥对reqData内的数据进行签名
//     */
//    @NotNull(message = "签名不能为空")
//    private String sign;
//
//    /**
//     * 签名算法
//     * 固定为“SHA-256”
//     */
//    @NotNull(message = "签名算法不能为空")
//    private String signType;
//
//    /**
//     * 请求时间
//     * 格式：yyyyMMddHHmmss
//     * 含义：商户发起该请求的当前时间，精确到秒
//     */
//    @NotNull(message = "请求时间不能为空")
//    @Size(max = 14, message = "请求时间长度超过14")
//    private String dateTime;
//
//    /**
//     * 订单日期
//     * 格式：yyyyMMdd
//     * 含义：订单的日期
//     */
//    @NotNull(message = "订单日期不能为空")
//    @Size(max = 8, message = "订单日期长度超过8")
//    private String date;
//
//    /**
//     * 订单号
//     * 6-32位数字或字母，由商户生成，一天内不能重复。
//     * 订单日期+订单号唯一定位一笔订单。
//     */
//    @NotNull(message = "订单号不能为空")
//    @Size(max = 32, message = "订单号长度超过32")
//    private String orderNo;
//
//
//    /**
//     * 过期时间跨度
//     * 必须为大于零的整数，单位为分钟。
//     * 该参数指定当前支付请求必须在指定时间跨度内完成（从系统收到支付请求开始计时），否则按过期处理。一般适用于航空客票等对交易完成时间敏 感的支付请求。
//     */
//    @Size(max = 2, message = "过期时间跨度长度超过2")
//    private String expireTimeSpan;
//
//    /**
//     * 成功支付结果通知地址
//     * 商户接收成功支付结果通知的地址，不能带商户参数。
//     */
//    @NotNull(message = "成功支付结果通知地址不能为空")
//    @Size(max = 256, message = "成功支付结果通知地址长度超过256")
//    private String payNoticeUrl;
//
//    /**
//     * 成功支付结果通知附加参数
//     * 该参数在发送成功支付结果通知时，将原样返回商户
//     * 注意：该参数可为空，商户如果需要不止一个参数，可以自行把参数组合、拼装，但组合后的结果不能带有’&’字符。
//     */
//    @Size(max = 256, message = "成功支付结果通知附加参数长度超过256")
//    private String payNoticePara;
//
//    /**
//     * 分行号
//     * 商户分行号，4位数字
//     */
//    @NotNull(message = "分行号不能为空")
//    @Size(max = 4, message = "分行号长度超过4")
//    private String branchNo;
//
//    /**
//     * 商户号
//     * 商户号，6位数字
//     */
//    @NotNull(message = "商户号不能为空")
//    @Size(max = 6, message = "商户号长度超过6")
//    private String merchantNo;
//
//    /**
//     * 成功页返回商户地址
//     * 支付成功页面上“返回商户”按钮跳转地址。为空则不显示返回商户按钮。
//     */
//    @Size(max = 256, message = "成功页返回商户地址长度超过256")
//    private String returnUrl;
//
//    /**
//     * 商户用户IP
//     * 商户取得的客户IP，如果有多个IP用逗号”,”分隔。
//     */
//    @Size(max = 64, message = "商户用户IP长度超过64")
//    private String clientIP;
//
//    /**
//     * 允许支付的卡类型
//     * 默认对支付卡种不做限制
//     * 如果为A，则只允许储蓄卡支付，禁止信用卡支付；其他值储蓄卡和信用卡均可支付
//     */
//    @Size(max = 1, message = "允许支付的卡类型长度超过1")
//    private String cardType;
//
//    /**
//     * 加密数据
//     * json格式写入的加密数据，并使用encrypType指定的算法加密
//     * 使用信息
//     * 使用encrypType指定的加密算法加密后的扩展信息。明文格式字符串格式如：{"addressCity":"440300","addressMobile":"18106989120","productType":"000518"}
//     * 注意：1.加密后的密文必须转换为16进制字符串
//     * 2.如果加密数据字段非空，该字段必填
//     */
//    private String encrypData;
//
//    /**
//     * RC4：使用RC4算法对加密数据进行加密，加密密钥为支付密钥。 DES：使用DES算法对加密数据进行加密，加密密钥为商户支付密钥的前8位，不足8位则右补0。 注意：如果加密数据字段非空，该字段必填
//     */
//    private String encrypType;
//
//    /**
//     * 二级商户编码
//     * 当前订单为商户的二级商户的订单时需要传送；必须为数字或英文字母
//     */
//    @Size(max = 30, message = "二级商户编码长度超过30")
//    private String subMerchantNo;
//
//    /**
//     * 二级商户名称
//     * 当前订单为商户的二级商户的订单时需要传送；
//     */
//    @Size(max = 100, message = "二级商户名称长度超过100")
//    private String subMerchantName;
//
//    /**
//     * 二级商户类别编码
//     * 当前订单为商户的二级商户的订单时需要传送；必须为数字或字母
//     */
//    @Size(max = 7, message = "二级商户类别编码长度超过7")
//    private String subMerchantTPCode;
//
//    /**
//     * 二级商户类别名称
//     * 当前订单为商户的二级商户的订单时需要传送；
//     */
//    @Size(max = 100, message = "二级商户类别名称长度超过100")
//    private String subMerchantTPName;
//
    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 商户用户IP
     * 商户取得的客户IP，如果有多个IP用逗号”,”分隔。
     */
    @Size(max = 64, message = "商户用户IP长度超过64")
    private String clientIP;

    //
//    public String getVersion() {
//        return version;
//    }
//
//    public void setVersion(String version) {
//        this.version = version;
//    }
//
//    public String getCharset() {
//        return charset;
//    }
//
//    public void setCharset(String charset) {
//        this.charset = charset;
//    }
//
//    public String getSign() {
//        return sign;
//    }
//
//    public void setSign(String sign) {
//        this.sign = sign;
//    }
//
//    public String getSignType() {
//        return signType;
//    }
//
//    public void setSignType(String signType) {
//        this.signType = signType;
//    }
//
    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    //
//    public String getDateTime() {
//        return dateTime;
//    }
//
//    public void setDateTime(String dateTime) {
//        this.dateTime = dateTime;
//    }
//
//    public String getDate() {
//        return date;
//    }
//
//    public void setDate(String date) {
//        this.date = date;
//    }
//
//    @Override
//    public String getOrderNo() {
//        return orderNo;
//    }
//
//    @Override
//    public void setOrderNo(String orderNo) {
//        this.orderNo = orderNo;
//    }
//
//    public String getExpireTimeSpan() {
//        return expireTimeSpan;
//    }
//
//    public void setExpireTimeSpan(String expireTimeSpan) {
//        this.expireTimeSpan = expireTimeSpan;
//    }
//
//    public String getPayNoticeUrl() {
//        return payNoticeUrl;
//    }
//
//    public void setPayNoticeUrl(String payNoticeUrl) {
//        this.payNoticeUrl = payNoticeUrl;
//    }
//
//    public String getPayNoticePara() {
//        return payNoticePara;
//    }
//
//    public void setPayNoticePara(String payNoticePara) {
//        this.payNoticePara = payNoticePara;
//    }
//
//    public String getBranchNo() {
//        return branchNo;
//    }
//
//    public void setBranchNo(String branchNo) {
//        this.branchNo = branchNo;
//    }
//
//    public String getMerchantNo() {
//        return merchantNo;
//    }
//
//    public void setMerchantNo(String merchantNo) {
//        this.merchantNo = merchantNo;
//    }
//
//    public String getReturnUrl() {
//        return returnUrl;
//    }
//
//    public void setReturnUrl(String returnUrl) {
//        this.returnUrl = returnUrl;
//    }
//
    public String getClientIP() {
        return clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }
//
//    public String getCardType() {
//        return cardType;
//    }
//
//    public void setCardType(String cardType) {
//        this.cardType = cardType;
//    }
//
//    public String getEncrypData() {
//        return encrypData;
//    }
//
//    public void setEncrypData(String encrypData) {
//        this.encrypData = encrypData;
//    }
//
//    public String getEncrypType() {
//        return encrypType;
//    }
//
//    public void setEncrypType(String encrypType) {
//        this.encrypType = encrypType;
//    }
//
//    public String getSubMerchantNo() {
//        return subMerchantNo;
//    }
//
//    public void setSubMerchantNo(String subMerchantNo) {
//        this.subMerchantNo = subMerchantNo;
//    }
//
//    public String getSubMerchantName() {
//        return subMerchantName;
//    }
//
//    public void setSubMerchantName(String subMerchantName) {
//        this.subMerchantName = subMerchantName;
//    }
//
//    public String getSubMerchantTPCode() {
//        return subMerchantTPCode;
//    }
//
//    public void setSubMerchantTPCode(String subMerchantTPCode) {
//        this.subMerchantTPCode = subMerchantTPCode;
//    }
//
//    public String getSubMerchantTPName() {
//        return subMerchantTPName;
//    }
//
//    public void setSubMerchantTPName(String subMerchantTPName) {
//        this.subMerchantTPName = subMerchantTPName;
//    }
}

