package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * @program: pay-center
 * @description: 招商银行一网通退款请求体 - 请求数据
 * @author: Simba
 * @create: 2019-09-27 15:14
 **/
public class RefundRequestReqDataBean implements Serializable {

    private static final long serialVersionUID = -936352983245114624L;
    /**
     * 商户发起该请求的当前时间，精确到秒。 格式：yyyyMMddHHmmss
     */
    private String dateTime;

    /**
     * 商户分行号，4位数字
     */
    private String branchNo;

    /**
     * 商户号，6位数字
     */
    private String merchantNo;

    /**
     * 商户订单日期，支付时的订单日期
     * 格式：yyyyMMdd
     */
    private String date;

    /**
     * 商户订单号，支付时的订单号
     */
    private String orderNo;

    /**
     * 退款流水号,商户生成，同一笔订单内，同一退款流水号只能退款一次。可用于防重复退款
     */
    private String refundSerialNo;

    /**
     * 退款金额,格式xxxx.xx
     */
    private String amount;

    /**
     * 退款描述
     */
    private String desc;

    /**
     * 商户结账系统的操作员号，选填，若填了则会对操作员号和密码进行校验，若不填则不校验
     */
    private String operatorNo;

    /**
     * 操作员密码加密算法,RC4：使用RC4算法对操作员密码进行加密，加密密钥为支付密钥。DES：使用DES算法对操作员密码进行加密，加密密钥为商户支付密钥的前8位，不足8位则右补0。空：默认不加密；
     */
    private String encrypType;

    /**
     * 操作员登录密码。使用encrypType算法加密后的密码
     * 注意：加密后的密文必须转换为16进制字符串表示
     */
    private String pwd;

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getBranchNo() {
        return branchNo;
    }

    public void setBranchNo(String branchNo) {
        this.branchNo = branchNo;
    }

    public String getMerchantNo() {
        return merchantNo;
    }

    public void setMerchantNo(String merchantNo) {
        this.merchantNo = merchantNo;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundSerialNo() {
        return refundSerialNo;
    }

    public void setRefundSerialNo(String refundSerialNo) {
        this.refundSerialNo = refundSerialNo;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getOperatorNo() {
        return operatorNo;
    }

    public void setOperatorNo(String operatorNo) {
        this.operatorNo = operatorNo;
    }

    public String getEncrypType() {
        return encrypType;
    }

    public void setEncrypType(String encrypType) {
        this.encrypType = encrypType;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
}

