/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.AppAccountChangeParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppAccountService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;

public class AppAccountServiceClient {
    private static final String DEVELOPER_ID = "developerId";
    private static final String RELATION_ID = "relationId";
    private static final String MONEY = "money";
    private static final String APP_ID = "appId";
    @Resource
    private RemoteAppAccountService remoteAppAccountService;

    public RpcResult<PayCenterResult> reduceMoney(AppAccountChangeParams param) {
        try {
            String sign = this.getSign(param);
            PayCenterResult ret = this.remoteAppAccountService.reduceMoney(param, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> addMoney(AppAccountChangeParams param) {
        try {
            String sign = this.getSign(param);
            PayCenterResult ret = this.remoteAppAccountService.addMoney(param, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    private String getSign(AppAccountChangeParams param) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVELOPER_ID, Objects.toString(param.getDeveloperId()));
        params.put(RELATION_ID, param.getRelationId());
        params.put(MONEY, Objects.toString(param.getMoney()));
        params.put(APP_ID, Objects.toString(param.getAppId()));
        return SignUtil.sign(params);
    }
}

