package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;
import cn.com.duiba.paycenter.enums.ChannelEnum;
import cn.com.duiba.paycenter.validator.MinExpireTime;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @author zhangruofan
 * @date 2018/11/20
 */
public class WxPayMpChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = 2799020269305957802L;
    /**
     * 终端设备信息
     * 可以不传
     */
    @Size(max = 32, message = "设备信息长度超过32")
    private String deviceInfo;
    /**
     * 订单标题
     * 会传给第三方支付
     */
    @NotNull(message = "支付描述不能为空")
    @Size(max = 128, message = "支付描述长度超过128")
    private String body;
    /**
     * 客户端ip地址
     * 获取用户真实ip
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5_sl.php?chapter=15_5
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String clientIp;
    /**
     * 授权码和openid二选一
     */
    @Size(max = 128, message = "授权码超过128")
    private String authCode;

    /**
     * 交易结束时间
     */
    @MinExpireTime
    private Date timeExpire;

    /**
     * 用户的微信openid和authCode二选一
     */
    private String openId;

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public Date getTimeExpire() {
        return timeExpire;
    }

    public void setTimeExpire(Date timeExpire) {
        this.timeExpire = timeExpire;
    }

    @Override
    public String getChannelType() {
        return ChannelEnum.WX_PUB.getChannelType();
    }

}
