package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.charge.ChargeOrderDto;
import cn.com.duiba.paycenter.dto.payment.charge.abc.AbcWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.abc.AbcWapChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.alipay.AlipayNativeChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.alipay.AlipayNativeChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.alipay.AlipayWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.alipay.AlipayWapChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.bankofsuzhou.BankOfSuZhouWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.bankofsuzhou.BankOfSuZhouWapChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.ccb.CcbWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.ccb.CcbWapChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.cmb.CmbOneNetPayRequest;
import cn.com.duiba.paycenter.dto.payment.charge.cmb.CmbOneNetPayResponse;
import cn.com.duiba.paycenter.dto.payment.charge.hello.HelloPayChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.hello.HelloPayChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.shouxin.ShouxinPayChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.shouxin.ShouxinPayChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wjrcb.WjrcbPayWxPubChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wjrcb.WjrcbPayWxPubChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.BuildAuthorizationUrlRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayLiteChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayLiteChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayMpChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayMpChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayNativeChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayNativeChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayWapChargeResponse;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/11/14
 */
@AdvancedFeignClient
public interface RemoteChargeService {
    /**
     * 微信H5支付收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayWapChargeResponse
     * @throws BizException bizException
     */
    WxPayWapChargeResponse createWxPayWapCharge(WxPayWapChargeRequest chargeRequest) throws BizException;

    /**
     * 微信公众号支付收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayMpChargeResponse
     * @throws BizException bizException
     */
    WxPayMpChargeResponse createWxPayMpCharge(WxPayMpChargeRequest chargeRequest) throws BizException;

    /**
     * 微信小程序收单接口
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     * @throws BizException bizException
     */
    WxPayLiteChargeResponse createWxPayLiteCharge(WxPayLiteChargeRequest chargeRequest) throws BizException;

    /**
     * 微信扫一扫收单接口
     * 返回扫一扫二维码
     * @param chargeRequest wxpay native charge
     * @return wxpay native response
     * @throws BizException bizException
     */
    WxPayNativeChargeResponse createWxPayNativeCharge(WxPayNativeChargeRequest chargeRequest) throws BizException;

    /**
     * 发起支付宝手机网站支付请求
     *
     * @param chargeRequest 支付请求参数
     * @return response
     * @throws BizException bizException
     */
    AlipayWapChargeResponse createAlipayWapCharge(AlipayWapChargeRequest chargeRequest) throws BizException;

    /**
     * 发起支付宝扫一扫支付请求
     * @param chargeRequest alipay native request
     * @return alipay response
     * @throws BizException bizException
     */
    AlipayNativeChargeResponse createAlipayNativeCharge(AlipayNativeChargeRequest chargeRequest) throws BizException;

    /**
     * 苏州银行支付
     * @param chargeRequest suzhou pay request
     * @return suzhou pay response
     * @throws BizException bizException
     */
    BankOfSuZhouWapChargeResponse createSuZhouCharge(BankOfSuZhouWapChargeRequest chargeRequest) throws BizException;


    /**
     * 建设银行支付
     * @param chargeRequest ccb pay request
     * @return ccb pay response
     * @throws BizException bizException
     */
    CcbWapChargeResponse createCcbCharge(CcbWapChargeRequest chargeRequest) throws BizException;
    /**
     * 苏州农商行微信公众号支付
     * @param chargeRequest wjrcb pay request
     * @return wjrcb pay response
     * @throws BizException bizException
     */
    WjrcbPayWxPubChargeResponse createWjrcbWxPubCharge(WjrcbPayWxPubChargeRequest chargeRequest) throws BizException;

    /**
     * 招商银行一网通支付
     * @param chargeRequest
     * @return
     * @throws BizException
     */
    CmbOneNetPayResponse createCmbOneNetCharge(CmbOneNetPayRequest chargeRequest) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param orderNo 支付订单号
     * @return chargeOrderDto
     * @throws BizException bizException
     */
    ChargeOrderDto findByOrderNo(String orderNo) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param orderNos 支付订单号
     * @return List<ChargeOrderDto>
     * @throws BizException bizException
     */
    List<ChargeOrderDto> batchFindByOrderNo(List<String> orderNos) throws BizException;

    /**
     * 构造oauth2授权的url连接
     *
     * @param appId       兑吧appId
     * @param redirectURI 跳转的url
     * @return url
     * @throws BizException bizException
     */
    String oauth2buildAuthorizationUrl(Long appId, String redirectURI) throws BizException;

    /**
     * 获取支付订单详情
     * @param bizNo 业务方流水号
     * @param bizType 业务方类型
     * @return ChargeOrderDto
     */
    ChargeOrderDto findByBizNoAndBizType(String bizNo, Integer bizType);

    /**
     * 农行支付
     * @param chargeRequest abc pay request
     * @return abc pay response
     * @throws BizException bizException
     */
    AbcWapChargeResponse createAbcCharge(AbcWapChargeRequest chargeRequest) throws BizException;

    /**
     * 构造oauth2授权的url连接  --  区分业务主体
     *
     * @return url
     * @throws BizException
     */
    String oauth2buildAuthorizationUrlBySubject(BuildAuthorizationUrlRequest request) throws BizException;

    /**
     * 哈啰零钱支付请求
     *
     * @param chargeRequest 支付请求参数
     * @return response
     * @throws BizException bizException
     */
    HelloPayChargeResponse createHelloPayCharge(HelloPayChargeRequest chargeRequest) throws BizException;

    /**
     * 首信支付请求
     *
     * @param chargeRequest 支付请求参数
     * @return response
     * @throws BizException bizException
     */
    ShouxinPayChargeResponse createShouxinPayCharge(ShouxinPayChargeRequest chargeRequest) throws BizException;

    /**
     * 微信小程序收单接口 - 客集集(临时)
     * @param chargeRequest 支付请求
     * @return WxPayLiteChargeResponse
     * @throws BizException bizException
     */
    WxPayLiteChargeResponse createWxPayLiteChargeForKejiji(WxPayLiteChargeRequest chargeRequest) throws BizException;


}
