package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author zhangruofan
 * @date 2018/11/20
 */
public class AlipayWapChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -5002740011734334288L;

    @Size(max = 255, message = "returnUrl不能超过255")
    private String returnUrl;
    /**
     * 用户付款中途退出返回商户网站的地址
     */
    @NotNull(message = "quitUrl不能为空")
    @Size(max = 400, message = "quitUrl不能超过400")
    private String quitUrl;
    /**
     * 商品的标题/交易标题/订单标题/订单关键字等。
     */
    @NotNull(message = "支付标题必填")
    @Size(max = 255, message = "支付标题最多255")
    private String subject;
    /**
     * 对一笔交易的具体描述信息。
     */
    @Size(max = 128, message = "body不能超过128")
    private String body;
    /**
     * 支付成功通知接收url
     */
    private String notifyUrl;

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getQuitUrl() {
        return quitUrl;
    }

    public void setQuitUrl(String quitUrl) {
        this.quitUrl = quitUrl;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}
