package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author zhangruofan
 * @date 2018/12/14
 */
public class WxPayNativeChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -2401619808914601403L;
    /**
     * 客户端ip地址
     * 获取用户真实ip
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5_sl.php?chapter=15_5
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String clientIp;
    /**
     * 订单标题
     * 会传给第三方支付
     */
    @NotNull(message = "支付描述不能为空")
    @Size(max = 128, message = "支付描述长度超过128")
    private String body;

    /**
     * 商品id
     * 此参数为二维码中包含的商品ID。
     */
    @NotNull(message = "productId must not be null")
    @Size(max = 32, message = "商品id不能超过32")
    private String productId;

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }
}
