package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * @program: pay-center
 * @description: 招行一网通查询支付结果响应体
 * @author: Simba
 * @create: 2020-01-14 20:01
 * <p>
 * 示例值:
 * {
 * "version":"1.0",
 * "charset":"utf-8",
 * "rspData":{
 * "rspCode":"SUC0000",
 * "rspMsg":"",
 * "dateTime":"20160825140752",
 * "branchNo":"0755",
 * "merchantNo":"000054",
 * "date":"20160503",
 * "orderNo":"9999030401",
 * "bankSerialNo":"16250327200000000020",
 * "currency":"10",
 * "orderAmount":"0.01",
 * "fee":"0.00",
 * "bankDate":"20160503",
 * "bankTime":"205620",
 * "settleAmount":"0.01",
 * "discountAmount":"0.00",
 * "orderStatus":"0",
 * "settleDate":"20160503",
 * "settleTime":"205620",
 * "cardType":"03",
 * "merchantPara":"para1"
 * }
 * }
 **/
public class CmbOneNetPayQuerySingleOrderResponse implements Serializable {

    private static final long serialVersionUID = -4519290753789216261L;
    /**
     * 接口版本号,固定为“1.0”
     */
    private String version;
    /**
     * 参数编码,固定为“UTF-8”
     */
    private String charset;

    private QuerySingleOrderResDataBean rspData;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public QuerySingleOrderResDataBean getRspData() {
        return rspData;
    }

    public void setRspData(QuerySingleOrderResDataBean rspData) {
        this.rspData = rspData;
    }
}

