package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * @program: pay-center
 * @description: 招商银行一网通退款请求体
 * @author: Simba
 * @create: 2019-09-27 10:50
 **/
public class CmbOneNetPayRefundRequest implements Serializable {


    private static final long serialVersionUID = 8535820434069399315L;
    /**
     * 接口版本号
     */
    private String version;

    /**
     * 参数编码,固定为”UTF-8”
     */
    private String charset;

    /**
     * 报文签名，使用招行私钥对noticeData内的数据进行签名；
     * 商户需使用招行公钥验签。
     */
    private String sign;

    /**
     * 签名算法，固定为”RSA”
     */
    private String signType;

    /**
     * 请求数据
     */
    private RefundRequestReqDataBean reqData;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public RefundRequestReqDataBean getReqData() {
        return reqData;
    }

    public void setReqData(RefundRequestReqDataBean reqData) {
        this.reqData = reqData;
    }

}

