package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.refund.RefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.RefundResponse;
import cn.com.duiba.paycenter.dto.payment.refund.abc.AbcRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.alipay.AlipayRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.boc.BocRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.citic.CiticRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.cmbonenet.CmbOneNetRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.mock.MockRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.shouxin.ShouxinPayRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.shouxin.ShouxinPayRefundResponse;
import cn.com.duiba.paycenter.dto.payment.refund.wjrcb.WjrcbRefundRequest;

/**
 * @author zhangruofan
 * @date 2018/11/26
 */
@AdvancedFeignClient
public interface RemoteRefundService {
    /**
     * 微信退款异步接口
     * 返回成功只是提交成功
     *
     * @param refundRequest 退款请求
     * @return 微信退款请求响应
     * @throws BizException bizException
     */
    RefundResponse refund(RefundRequest refundRequest) throws BizException;

    /**
     * 支付宝同步退款请求
     * 返回成功即退款成功
     *
     * @param alipayRefundRequest 支付宝退款请求
     * @return RefundResponse
     * @throws BizException bizException
     */
    RefundResponse alipayRefund(AlipayRefundRequest alipayRefundRequest) throws BizException;

    /**
     * 苏州农商行退款请求
     * @param refundRequest refund request
     * @return refund response
     * @throws BizException bizException
     */
    RefundResponse wjrcbRefund(WjrcbRefundRequest refundRequest) throws BizException;

    /**
     * 获取退款详情
     * @param request 退款请求类
     * @return RefundOrderDto
     */
    RefundResponse abcRefund(AbcRefundRequest request);

    /**
     * 中国银行 退款
     * @param request
     * @return
     */
    RefundResponse bocRefund(BocRefundRequest request);

    /**
     * 中信银行 退款
     * @param request
     * @return
     */
    RefundResponse citicRefund(CiticRefundRequest request);

    /**
     * 招行一网通支付退款请求
     * @param refundRequest refund request
     * @return refund response
     * @throws BizException bizException
     */
    RefundResponse cmbOneNetPayRefund(CmbOneNetRefundRequest refundRequest) throws BizException;

    /**
     * 首信支付退款请求
     * @param refundRequest refund request
     * @return refund response
     * @throws BizException bizException
     */
    ShouxinPayRefundResponse shouxinPayRefund(ShouxinPayRefundRequest refundRequest) throws BizException;

    /**
     * mock退款
     * @param request
     * @return
     */
    RefundResponse mockRefund(MockRefundRequest request) throws BizException;
}
