package cn.com.duiba.paycenter.dto.payment.charge.citic;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author liukai
 * @date 2020/03/12 19:24
 */
public class CiticWapChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 8761721069477341839L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 订单时间 yyyyMMdd HHmmss
     */
    @NotNull(message = "订单时间不能为空")
    private String createDate;

    @NotNull(message = "商品类型不能为空")
    private String itemType;

    @NotNull(message = "消费者id不能为空")
    private String consumerId;

    @NotNull(message = "回调地址不能为空")
    private String callbackUrl;

    //供应商标识，南宁中信会有，南京中信没有
    private Integer supplierTag;

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public Integer getSupplierTag() {
        return supplierTag;
    }

    public void setSupplierTag(Integer supplierTag) {
        this.supplierTag = supplierTag;
    }
}
