package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.refund.RefundOrderDto;

/**
 * @author zhangruofan
 * @date 2019/02/26
 */
@AdvancedFeignClient
public interface RemoteRefundBackendService {
    /**
     * 获取退款详情
     * @param transactionNo 第三方支付单号
     * @return RefundOrderDto
     */
    RefundOrderDto findByTransactionNo(String transactionNo);

    /**
     * 通过退款流水号查找退款订单流水
     * @param refundOrderNo 退款单号
     * @return  退款流水entity
     */
    RefundOrderDto findByRefundOrderNo(String refundOrderNo);
}
