package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.charge.duibaLive.installment.DuibaLiveInstallmentNotifyResponse;
import cn.com.duiba.paycenter.dto.payment.charge.duibaLive.mp.DuibaLiveMpNotifyResponse;
import cn.com.duiba.paycenter.dto.payment.refund.wxpay.WxPayRefundNotifyResponse;

import java.util.Map;

/**
 * @Author xujing
 * @Date 2021/5/18 3:55 下午
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveNotifyService {
    /**
     * 兑吧直播小程序支付通知
     * @param params
     * @return
     * @throws BizException
     */
    DuibaLiveMpNotifyResponse orderNotify(Map<String,String> params) throws BizException;

    /**
     * 兑吧直播小程序支付通知(直连)
     * @param xmlData
     * @return
     * @throws BizException
     */
    DuibaLiveMpNotifyResponse wxOrderNotify(String xmlData) throws BizException;

    /**
     * 退款通知接口
     * @param xmlData
     * @return
     * @throws BizException
     */
    WxPayRefundNotifyResponse refundNotify(String xmlData) throws BizException;


    /**
     * 兑吧直播分期支付通知
     * @param params
     * @return
     * @throws BizException
     */
    DuibaLiveInstallmentNotifyResponse installmentOrderNotify(Map<String,String> params) throws BizException;
}
