package cn.com.duiba.paycenter.message;

import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxTransferPaySendRequest;
import cn.com.duiba.paycenter.result.FundTransferResult;
import cn.com.duiba.wolf.utils.GZIPUtils;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;

public class WxTransferCallbackMessage implements Serializable {
    private static final long serialVersionUID = -158540658712524775L;

    private WxTransferPaySendRequest requestParams;

    private FundTransferResult result;

    public WxTransferPaySendRequest getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(WxTransferPaySendRequest requestParams) {
        this.requestParams = requestParams;
    }

    public FundTransferResult getResult() {
        return result;
    }

    public void setResult(FundTransferResult result) {
        this.result = result;
    }


    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static WxTransferCallbackMessage decode(byte[] msg) {
        String string = GZIPUtils.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, WxTransferCallbackMessage.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param msg
     * @return
     */
    public static byte[] encode(WxTransferCallbackMessage msg) {
        String string = JSONObject.toJSONString(msg);
        return GZIPUtils.gzip(string);
    }
}
