package cn.com.duiba.paycenter.dto.payment.charge.unionpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;


public class UnionPayWapChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 3757091614551720276L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;


    /**
     * 支付结果通知的地址，不传则走默认配置
     */
    private String resultNotifyUrl;

    /**
     * 针对二维码支付
     * 交易子类，二维码消费
     */
    private String subType;

    /**
     * 针对二维码支付
     * C2B 码
     */
    private String qrCode;

    /**
     * 商户代码 merId、商户订单号 orderId、订单发送时间 txnTime 三要素唯一确定一笔交易
     */
    @NotNull
    private String merId;


    public String getMerId() {
        return merId;
    }

    public void setMerId(String merId) {
        this.merId = merId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getResultNotifyUrl() {
        return resultNotifyUrl;
    }

    public void setResultNotifyUrl(String resultNotifyUrl) {
        this.resultNotifyUrl = resultNotifyUrl;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }
}
